local Screen = require "widgets.screen"
local Text = require "widgets.text"
local easing = require "util.easing"
local templates = require "widgets.ftf.templates"
local Image = require "widgets.image"
local Widget = require("widgets/widget")
local krandom = require("util.krandom")

local OpenSourceCreditsScreen = Class(Screen, function(self, player)
	Screen._ctor(self, "OpenSourceCreditsScreen")

	-- Add background
	self.bg = self:AddChild(templates.BackgroundImage("images/ui_ftf_pausescreen/background_gradient.tex"))
	self.container = self:AddChild(Image("images/bg_popup_flat/popup_flat.tex"))
		:SetScale(1.125, 1.125)

	self.title = self.container:AddChild(Text(FONTFACE.DEFAULT, 108))
		:LeftAlign()
		:LayoutBounds("center", "top", self.container)
		:Offset(0, -150)
		:SetGlyphColor(UICOLORS.LIGHT_TEXT_DARK)
		:SetText(STRINGS.UI.CREDITSSCREEN.OPENSOURCE)

	self.title_decor_left = self.container:AddChild(Image("images/ui_ftf_inventory/InventoryTitleDecorLeft.tex"))
		:SetSize(80, 80)
		:SetMultColor(UICOLORS.LIGHT_TEXT_DARK)
		:SetMultColorAlpha(0.5)
		:LayoutBounds("before", "center", self.title)
		:SetScale(1.2, 1.2)
		:Offset(-20, 0)

	self.title_decor_right = self.container:AddChild(Image("images/ui_ftf_inventory/InventoryTitleDecorRight.tex"))
		:SetSize(80, 80)
		:SetMultColor(UICOLORS.LIGHT_TEXT_DARK)
		:SetMultColorAlpha(0.5)
		:LayoutBounds("after", "center", self.title)
		:SetScale(1.2, 1.2)
		:Offset(20, 0)

	self.page1_widget = self.container:AddChild(Widget("Page 1"))
	self.page2_widget = self.container:AddChild(Widget("Page 2"))

	local page1 = {}
	local page2 = {}
	for i=1, #STRINGS.CREDITS.OPENSOURCE do
		if i < #STRINGS.CREDITS.OPENSOURCE / 2 then
			table.insert(page1, STRINGS.CREDITS.OPENSOURCE[i])
		else
			table.insert(page2, STRINGS.CREDITS.OPENSOURCE[i])
		end
	end

	self.names_per_column = 18
	self:GenerateCredits(page1, self.page1_widget)
	self:GenerateCredits(page2, self.page2_widget)

	self.page2_widget:Hide()

	self.pages =
	{
		self.page1_widget,
		self.page2_widget
	}

	-- Back button
	self.button = self:AddChild(templates.Button(STRINGS.UI.BUTTONS.NEXT))
		:SetPrimary()
		:LayoutBounds("center", "bottom", self.bg)
		:Offset(30, 20)
		:SetSize(BUTTON_W - (50 * HACK_FOR_4K), BUTTON_H)

	self.button:SetOnClick(function()
		local old_page = self.current_page
		self.current_page = self.current_page + 1
		
		if self.current_page == #self.pages then
			self.button:SetText(STRINGS.UI.BUTTONS.CLOSE)
		end

		if self.current_page > #self.pages then
			TheFrontEnd:PopScreen(self)
		else
			self.pages[old_page]:Hide()
			self.pages[self.current_page]:Show()
		end
	end)

	self.default_focus = self.button
	self.current_page = 1
	self.credit_names = self.container:AddChild(Widget("Credit names"))
		:LayoutBounds("left", "top", self.container)
end)

OpenSourceCreditsScreen.CONTROL_MAP = 
{
	{
		control = Controls.Digital.CANCEL,
		hint = function(self, left, right)
			table.insert(right, loc.format(LOC"UI.CONTROLS.CANCEL", Controls.Digital.CANCEL))
		end,
		fn = function(self)
			TheFrontEnd:PopScreen(self)
			return true
		end,
	},
}

function OpenSourceCreditsScreen:GenerateCredits(str_tbl, names_parent)
	local credit_names = names_parent:AddChild(Widget("Names"))

	local names = krandom.Shuffle(shallowcopy(str_tbl))

	local count = 0
	local credits_column = credit_names:AddChild(Widget("Credits Column"))
	for i, name in ipairs(names) do
		if count == self.names_per_column then
			credits_column:LayoutChildrenInColumn(18, "left")
			credits_column = credit_names:AddChild(Widget("Credits Column"))
			count = 0
		end

		credits_column:AddChild(Text(FONTFACE.BODYTEXT, 48))
			:SetText(name)
			:SetGlyphColor(UICOLORS.LIGHT_TEXT_DARK)

		count = count + 1
	end
	credits_column:LayoutChildrenInColumn(20, "left")

	credit_names
		:LayoutChildrenInRow(150, "left")
		:MoveToFront()
		:LayoutBounds("center", "top", self.container)
		:Offset(0, -240)
end


return OpenSourceCreditsScreen